﻿'版权所有 (C) 2005 Microsoft Corporation
Option Strict On


Public Class SingleCallCustomer
    Inherits MarshalByRefObject

    '用于存储客户属性值的私有字段
    Private m_Age As Byte = 0
    Private m_Name As String = "<<Uninitialized>>"

    ' 创建了存储时间对象实例的私有字段。
    Private ReadOnly mdteCreationTime As DateTime = Date.Now

    '默认的无参数构造函数
    Public Sub New()
        MyBase.New()
    End Sub

    'Age 的属性实现
    Public Property Age() As Byte
        Get
            Return m_Age
        End Get

        Set(ByVal Value As Byte)
            If Value > 0 Then
                m_Age = Value
            Else
                m_Age = 0
            End If
        End Set
    End Property

    'Name 的属性实现
    Public Property Name() As String
        Get
            Return m_Name
        End Get
        Set(ByVal Value As String)
            m_Name = Value
        End Set
    End Property

    ' 接受对 Name 和 Age 的更改并将相应的值作为字符串返回
    Public Function UpdateCustomerInfo(ByVal NewName As String, ByVal NewAge As Byte) As String
        ' 更新局部属性
        Me.Name = NewName
        Me.Age = NewAge

        ' 在此处进行更新数据库之类的工作（留给读者进行练习）。

        Return String.Format("Customer Name is {0}. Customer Age is {1}", Me.Name, Me.Age)
    End Function

    ' 下列属性用于获取组件的信息（仅用于测试）。
    ' 使用
    ' AssemblyInfo 类（在 AssemblyInfo.vb 文件中定义）来检索某些信息。
    ' 所有成员都使用 Debug 关键字来修饰，用以指明它们的
    ' 测试状态，以便于在 IntelliSense 中查找它们。

    ' CodeBase 将返回组件运行时所在的物理 
    ' 路径。
    Public ReadOnly Property DebugCodeBase() As String
        Get
            Dim myType As Type = GetType(SingleCallCustomer)
            Return myType.Assembly.CodeBase
        End Get
    End Property

    ' 返回程序集的完全限定名
    Public ReadOnly Property DebugFQName() As String
        Get
            Dim myType As Type = GetType(SingleCallCustomer)
            Return myType.Assembly.GetName.FullName.ToString()
        End Get
    End Property

    ' 返回当前对象实例的创建日期和时间。
    Public ReadOnly Property DebugCreationTime() As DateTime
        Get
            Return mdteCreationTime
        End Get
    End Property

    ' 返回运行该对象的计算机的名称。
    Public ReadOnly Property DebugHostName() As String
        Get
            Return System.Environment.MachineName
        End Get
    End Property
End Class

